/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.entity.Registry;
import aeonics.entity.Step;
import aeonics.template.Item;
import aeonics.template.Parameter;
import aeonics.template.Relationship;
import aeonics.template.Template;
import aeonics.util.StringUtils;
import aeonics.util.Tuples;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.function.Supplier;

public class Flow
extends Item<Type> {
    @Override
    protected Class<? extends Type> defaultTarget() {
        return Type.class;
    }

    @Override
    protected Supplier<? extends Type> defaultCreator() {
        return Type::new;
    }

    @Override
    protected Class<? extends Item<? super Type>> category() {
        return Flow.class;
    }

    @Override
    public Template<? extends Type> template() {
        return ((Template)((Template)((Template)((Template)super.template().summary("Data flow")).description("A data flow is a high-level representation used to regroup interconnected elements of a data pipeline.")).add((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("size").summary("Size")).description("The grid size of the data flow.")).format("number")).rule(Parameter.Rule.INTEGER).defaultValue(5))).add(((Parameter)((Parameter)((Parameter)new Parameter("notes").summary("Notes")).description("Notes about this data flow.")).format("text")).optional(true))).add((Relationship)((Relationship)((Relationship)((Relationship)((Relationship)new Relationship("steps").summary("Steps")).description("The different steps that are part of this data flow.")).category(Step.class)).add((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("x").summary("X")).description("The X position in the data flow grid")).format("number")).rule(Parameter.Rule.INTEGER).defaultValue(0))).add((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("y").summary("Y")).description("The Y position in the data flow grid")).format("number")).rule(Parameter.Rule.INTEGER).defaultValue(0)));
    }

    public static class Type
    extends Entity
    implements Closeable {
        @Override
        public final String category() {
            return StringUtils.toLowerCase(Flow.class);
        }

        public <T extends Type> T step(Step.Type type, int n, int n2) {
            for (Tuples.Tuple tuple : this.relations("steps")) {
                if (tuple.a != type) continue;
                ((Data)tuple.b).put("x", n).put("y", n2);
                return (T)this;
            }
            this.addRelation("steps", type, Data.map().put("x", n).put("y", n2));
            return (T)this;
        }

        @Override
        public void close() {
            ArrayList<Step.Type> arrayList = new ArrayList<Step.Type>();
            for (Tuples.Tuple tuple : this.relations("steps")) {
                if (tuple.a == null || ((Entity)tuple.a).internal()) continue;
                arrayList.add((Step.Type)((Entity)tuple.a).cast());
            }
            this.clearRelation("steps");
            arrayList.forEach(type -> Registry.of(Step.class).remove((Entity)type));
        }
    }
}

