/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity;

import aeonics.data.Data;
import aeonics.entity.Discard;
import aeonics.entity.Entity;
import aeonics.entity.Flow;
import aeonics.entity.Message;
import aeonics.entity.Registry;
import aeonics.entity.security.User;
import aeonics.manager.Executor;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Monitor;
import aeonics.manager.Network;
import aeonics.manager.Scheduler;
import aeonics.template.Channel;
import aeonics.template.Item;
import aeonics.template.Parameter;
import aeonics.template.Relationship;
import aeonics.util.Functions;
import aeonics.util.StringUtils;
import aeonics.util.Tuples;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class Step
extends Item<Type> {
    @Override
    protected final Class<? extends Step> category() {
        return Step.class;
    }

    public Template template() {
        return (Template)((aeonics.template.Template)new Template(this.target(), (Class<? extends Step>)this.getClass(), this.category()).creator(this.creator())).cast();
    }

    public static abstract class Destination
    extends Step {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template template() {
            return ((Template)((Template)((Template)super.template().inputEnabled(true)).outputEnabled(false)).role(ROLE.DESTINATION)).icon("where_to_vote");
        }

        public static class Type
        extends aeonics.entity.Step$Type {
            private Functions.BiConsumer<Message, String> processor = null;

            public <T extends Type> T processor(Functions.BiConsumer<Message, String> biConsumer) {
                this.processor = biConsumer;
                return (T)this;
            }

            protected void process(Message message, String string) throws Exception {
                if (this.processor != null) {
                    this.processor.accept(message, string);
                }
            }
        }
    }

    public static abstract class Action
    extends Step {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template template() {
            return ((Template)((Template)((Template)super.template().inputEnabled(true)).outputEnabled(true)).role(ROLE.ACTION)).icon("crop_rotate");
        }

        public static class Type
        extends aeonics.entity.Step$Type {
            private Functions.TriFunction<Message, String, String, Message> processor = null;

            public <T extends Type> T processor(Functions.TriFunction<Message, String, String, Message> triFunction) {
                this.processor = triFunction;
                return (T)this;
            }

            protected Message process(Message message, String string, String string2) throws Exception {
                if (this.processor != null) {
                    return this.processor.apply(message, string, string2);
                }
                return null;
            }
        }
    }

    public static class Origin
    extends Step {
        @Override
        protected Class<? extends Type> defaultTarget() {
            return Type.class;
        }

        @Override
        protected Supplier<? extends Type> defaultCreator() {
            return Type::new;
        }

        @Override
        public Template template() {
            return ((Template)((Template)((Template)super.template().inputEnabled(false)).outputEnabled(true)).role(ROLE.ORIGIN)).icon("cloud_upload");
        }

        public static class NetworkClient
        extends Type {
            private Network.Connection connection = null;
            private Supplier<Network.Connection> connect = null;

            public Network.Connection connect() throws Exception {
                if (this.connect != null) {
                    return this.connect.get();
                }
                throw new IllegalStateException("Connect function is not set");
            }

            public <T extends NetworkClient> T connect(Supplier<Network.Connection> supplier) {
                this.connect = supplier;
                return (T)this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void start() {
                NetworkClient networkClient = this;
                synchronized (networkClient) {
                    if (!this.stopped()) {
                        return;
                    }
                    this.starting(true);
                    this.start2();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void start2() {
                NetworkClient networkClient = this;
                synchronized (networkClient) {
                    block6: {
                        if (!this.starting()) {
                            return;
                        }
                        try {
                            this.connection = this.connect();
                            this.connection.onClose().then((void_, connection) -> {
                                if (!this.stopping() && !this.stopped()) {
                                    Manager.of(Scheduler.class).in(zonedDateTime -> {
                                        this.starting(true);
                                        this.start2();
                                    }, 1000L);
                                }
                            });
                            this.started(true);
                        }
                        catch (Exception exception) {
                            Manager.of(Logger.class).severe(this.getClass(), (Throwable)exception);
                            if (this.stopping() || this.stopped()) break block6;
                            Manager.of(Scheduler.class).in(zonedDateTime -> {
                                this.starting(true);
                                this.start2();
                            }, 1000L);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stop() {
                NetworkClient networkClient = this;
                synchronized (networkClient) {
                    this.stopping(true);
                    if (this.connection != null) {
                        try {
                            this.connection.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.stopped(true);
                }
            }
        }

        public static class NetworkServer
        extends Type {
            private Network.Server server = null;
            private Supplier<Network.Server> connect = null;

            public Network.Server connect() throws Exception {
                if (this.connect != null) {
                    return this.connect.get();
                }
                throw new IllegalStateException("Connect function is not set");
            }

            public <T extends NetworkServer> T connect(Supplier<Network.Server> supplier) {
                this.connect = supplier;
                return (T)this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void start() {
                NetworkServer networkServer = this;
                synchronized (networkServer) {
                    if (!this.stopped()) {
                        return;
                    }
                    this.starting(true);
                    this.start2();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void start2() {
                NetworkServer networkServer = this;
                synchronized (networkServer) {
                    block6: {
                        if (!this.starting()) {
                            return;
                        }
                        try {
                            this.server = this.connect();
                            this.server.onClose().then((void_, server) -> {
                                if (!this.stopping() && !this.stopped()) {
                                    Manager.of(Scheduler.class).in(zonedDateTime -> {
                                        this.starting(true);
                                        this.start2();
                                    }, 1000L);
                                }
                            });
                            this.started(true);
                        }
                        catch (Exception exception) {
                            Manager.of(Logger.class).severe(this.getClass(), (Throwable)exception);
                            if (this.stopping() || this.stopped()) break block6;
                            Manager.of(Scheduler.class).in(zonedDateTime -> {
                                this.starting(true);
                                this.start2();
                            }, 1000L);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stop() {
                NetworkServer networkServer = this;
                synchronized (networkServer) {
                    this.stopping(true);
                    if (this.server != null) {
                        try {
                            this.server.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.stopped(true);
                }
            }
        }

        public static class Background
        extends Type
        implements Runnable {
            private Runnable run = null;
            private Executor.Task<Void> task = null;

            public <T extends Background> T run(Runnable runnable) {
                this.run = runnable;
                return (T)this;
            }

            @Override
            public void run() {
                if (this.run == null) {
                    throw new IllegalStateException("Run function is not set");
                }
                this.run.run();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void start() {
                Background background = this;
                synchronized (background) {
                    if (!this.stopped()) {
                        return;
                    }
                    this.starting(true);
                    if (this.task == null) {
                        this.task = Manager.of(Executor.class).background(() -> {
                            this.started(true);
                            while (!this.stopping()) {
                                try {
                                    this.run();
                                }
                                catch (Exception exception) {
                                    Manager.of(Logger.class).severe(this.getClass(), (Throwable)exception);
                                }
                                if (this.stopping()) continue;
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                    break;
                                }
                            }
                            this.stopped(true);
                        });
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stop() {
                Background background = this;
                synchronized (background) {
                    if (!this.started()) {
                        return;
                    }
                    this.stopping(true);
                    if (this.task != null) {
                        this.task.cancel();
                    }
                }
            }
        }

        public static class Type
        extends aeonics.entity.Step$Type
        implements Closeable {
            private int state = 0;
            private Runnable start = null;
            private Runnable stop = null;

            public void produce(Message message, String string) {
                this.emit(message, string);
            }

            public boolean stopped() {
                return this.state == 0;
            }

            public void stopped(boolean bl) {
                if (bl) {
                    this.state = 0;
                }
            }

            public boolean starting() {
                return this.state == 1;
            }

            public void starting(boolean bl) {
                if (bl) {
                    this.state = 1;
                }
            }

            public boolean started() {
                return this.state == 2;
            }

            public void started(boolean bl) {
                if (bl) {
                    this.state = 2;
                }
            }

            public boolean stopping() {
                return this.state == 3;
            }

            public void stopping(boolean bl) {
                if (bl) {
                    this.state = 3;
                }
            }

            public void start() {
                if (this.start != null) {
                    this.start.run();
                } else {
                    this.started(true);
                }
            }

            public <T extends Type> T start(Runnable runnable) {
                this.start = runnable;
                return (T)this;
            }

            public void stop() {
                if (this.stop != null) {
                    this.stop.run();
                } else {
                    this.stopped(true);
                }
            }

            public <T extends Type> T stop(Runnable runnable) {
                this.stop = runnable;
                return (T)this;
            }

            @Override
            public void close() {
                this.stop();
            }
        }
    }

    public static abstract class Type
    extends Entity
    implements Closeable {
        private Functions.TriConsumer<User.Type, Data, String> security = null;

        @Override
        public void close() {
            for (Entity entity : Registry.of(Flow.class)) {
                entity.removeRelation("steps", this);
            }
            for (Entity entity : Registry.of(Step.class)) {
                entity.removeRelation("links", this);
            }
        }

        public <T extends Type> T security(Functions.TriConsumer<User.Type, Data, String> triConsumer) {
            this.security = triConsumer;
            return (T)this;
        }

        private void checkSecurity(User.Type type, Data data, String string) throws Exception {
            if (this.security != null) {
                this.security.accept(type, data, string);
            }
        }

        @Override
        public final String category() {
            return StringUtils.toLowerCase(Step.class);
        }

        public <T extends Type> T link(String string, Type type, String string2) {
            return this.link(string, type, string2, Data.map());
        }

        public <T extends Type> T link(String string, Type type, String string2, Data data) {
            boolean bl = false;
            for (Channel object : ((Template)this.template().cast()).outputs()) {
                if (!object.name().equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalArgumentException("Invalid output name: " + string);
            }
            for (Channel channel : ((Template)type.template().cast()).inputs()) {
                if (!channel.name().equals(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalArgumentException("Invalid input name: " + string2);
            }
            for (Tuples.Tuple tuple : this.relations("links")) {
                if (tuple.a != type || !((Data)tuple.b).asString("output").equals(string) || !((Data)tuple.b).asString("input").equals(string2)) continue;
                return (T)this;
            }
            if (data == null || data.isNull()) {
                data = Data.map();
            }
            if (!data.isMap()) {
                throw new IllegalArgumentException("Invalid relation parameters: " + data);
            }
            this.addRelation("links", type, data.put("output", string).put("input", string2));
            return (T)this;
        }

        public <T extends Type> T unlink(String string, Type type, String string2) {
            Iterator iterator = this.relations("links").iterator();
            while (iterator.hasNext()) {
                Tuples.Tuple tuple = iterator.next();
                if (tuple.a != type || !((Data)tuple.b).asString("output").equals(string) || !((Data)tuple.b).asString("input").equals(string2)) continue;
                iterator.remove();
            }
            return (T)this;
        }

        private Executor.Task<Executor.Task<Void>> doEmit(Message message, String string, Type type, String string2) {
            if (message == null || type == null || string == null || string2 == null) {
                return Manager.of(Executor.class).normalResolved(Manager.of(Executor.class).normalResolved(null));
            }
            if (string.equals("error") && message.metadata().asBool("ignored") || string.equals("ignore") && message.metadata().asBool("ignored")) {
                Discard.error(message, new Exception("Infinite message routing loop"));
                return Manager.of(Executor.class).normalResolved(Manager.of(Executor.class).normalResolved(null));
            }
            if (message.metadata().asInt("ttl") <= 0) {
                Discard.expired(message);
                return Manager.of(Executor.class).normalResolved(Manager.of(Executor.class).normalResolved(null));
            }
            if (string.equals("ignore")) {
                message.metadata().put("ignored", true);
            } else if (string.equals("error")) {
                message.metadata().put("errored", true);
            }
            message.metadata().put("ttl", message.metadata().asInt("ttl") - 1);
            return Manager.of(Executor.class).normal(() -> type.accept(message, string2));
        }

        Executor.Task<Void> emit(Message message, String string) {
            if (this instanceof Destination.Type && !string.equals("error") && !string.equals("ignore")) {
                message.metadata().put("error", new IllegalStateException("Invalid output channel for destination step: " + string));
                return this.emit(message, "error");
            }
            List<Tuples.Tuple<Entity, Data>> list = this.collectLinks(string);
            if (list.size() == 0) {
                if (string.equals("ignore")) {
                    Discard.error(message, new Exception("Infinite message routing loop"));
                    return Manager.of(Executor.class).normalResolved(null);
                }
                return this.emit(message, "ignore");
            }
            ArrayList arrayList = new ArrayList(list.size());
            boolean bl = list.size() > 1;
            list.forEach(tuple -> {
                Executor.Task<Executor.Task<Void>> task2 = this.doEmit(bl ? message.clone() : message, string, (Type)((Entity)tuple.a).cast(), string);
                arrayList.add(task2.link(task -> task));
            });
            return Manager.of(Executor.class).normal(arrayList);
        }

        List<Tuples.Tuple<Entity, Data>> collectLinks(String string) {
            ArrayList<Tuples.Tuple<Entity, Data>> arrayList = new ArrayList<Tuples.Tuple<Entity, Data>>();
            for (Tuples.Tuple tuple : this.relations("links")) {
                if (tuple.a == null || !((Data)tuple.b).asString("output").equals(string) || !(tuple.a instanceof Action.Type) && !(tuple.a instanceof Destination.Type)) continue;
                arrayList.add(tuple);
            }
            return arrayList;
        }

        Executor.Task<Void> accept(Message message, String string) {
            try (Monitor.MonitorTimer monitorTimer = Manager.of(Monitor.class).ns(this);){
                this.context(Data.of(message));
                if (this instanceof Origin.Type) {
                    message.metadata().put("error", new IllegalStateException("Invalid accept operation for origin step"));
                    Executor.Task<Void> task = this.emit(message, "error");
                    return task;
                }
                try {
                    this.checkSecurity((User.Type)Registry.of(User.class).get(message.user()), message.content(), string);
                }
                catch (Exception exception) {
                    message.metadata().put("error", exception);
                    Executor.Task<Void> task = this.emit(message, "error");
                    if (monitorTimer != null) {
                        monitorTimer.close();
                    }
                    return task;
                }
                if (this instanceof Destination.Type) {
                    Executor.Task<Void> task = this.acceptDestination(message, string);
                    return task;
                }
                if (this instanceof Action.Type) {
                    Executor.Task<Void> task = this.acceptAction(message, string);
                    return task;
                }
                message.metadata().put("error", new IllegalStateException("Invalid step type: " + this.getClass().getName()));
                Executor.Task<Void> task = this.emit(message, "error");
                return task;
            }
        }

        Executor.Task<Void> acceptDestination(Message message, String string) {
            try {
                ((Destination.Type)this.cast()).process(message, string);
                return Manager.of(Executor.class).normalResolved(null);
            }
            catch (Exception exception) {
                message.metadata().put("error", exception);
                return this.emit(message, "error");
            }
        }

        Executor.Task<Void> acceptAction(Message message, String string) {
            ArrayList arrayList = new ArrayList();
            Map<String, List<Tuples.Tuple<Entity, Data>>> map = this.aggregateLinks();
            map.forEach((string2, list2) -> {
                if (string2.equals("error") || string2.equals("ignore")) {
                    return;
                }
                if (list2.size() == 0) {
                    return;
                }
                try {
                    Message message2 = ((Action.Type)this.cast()).process(map.size() > 1 ? message.clone() : message, string, (String)string2);
                    if (message2 == null) {
                        return;
                    }
                    this.forward(message2, (String)string2, (List<Tuples.Tuple<Entity, Data>>)list2, arrayList);
                }
                catch (Exception exception) {
                    Message message3 = map.size() > 1 ? message.clone() : message;
                    message3.metadata().put("error", exception);
                    this.forward(message3, (String)string2, (List)map.get("error"), arrayList);
                }
            });
            if (arrayList.size() == 0) {
                this.forward(message, "ignore", map.get("ignore"), arrayList);
            }
            if (arrayList.size() == 0) {
                return this.emit(message, "ignore");
            }
            return Manager.of(Executor.class).normal(arrayList);
        }

        Map<String, List<Tuples.Tuple<Entity, Data>>> aggregateLinks() {
            HashMap<String, List<Tuples.Tuple<Entity, Data>>> hashMap = new HashMap<String, List<Tuples.Tuple<Entity, Data>>>();
            ((Template)this.template().cast()).outputs().forEach(channel -> {
                List<Tuples.Tuple<Entity, Data>> list = this.collectLinks(channel.name());
                if (list != null && list.size() > 0) {
                    hashMap.put(channel.name(), list);
                }
            });
            return hashMap;
        }

        void forward(Message message, String string, List<Tuples.Tuple<Entity, Data>> list, List<Executor.Task<?>> list2) {
            if (list == null) {
                return;
            }
            boolean bl = list.size() > 1;
            list.forEach(tuple -> {
                Executor.Task<Executor.Task<Void>> task2 = this.doEmit(bl ? message.clone() : message, string, (Type)((Entity)tuple.a).cast(), ((Data)tuple.b).asString("input"));
                list2.add(task2.link(task -> task));
            });
        }
    }

    public static class Template
    extends aeonics.template.Template<Type> {
        private boolean inputEnabled = true;
        private boolean outputEnabled = true;
        private List<Channel> inputs = new ArrayList<Channel>();
        private List<Channel> outputs = new ArrayList<Channel>();
        private String icon = null;
        private ROLE role = null;

        public Template(Class<? extends Type> clazz, Class<? extends Step> clazz2, Class<? extends Step> clazz3) {
            super(clazz, clazz2, clazz3);
            this.add((Relationship)((Relationship)((Relationship)((Relationship)((Relationship)new Relationship("links").category(Step.class)).summary("Next flow step")).description("The next step to send data after processing.")).add((Parameter)((Parameter)((Parameter)new Parameter("input").summary("Input Channel")).description("The name of the input channel of the target step.")).format("text"))).add((Parameter)((Parameter)((Parameter)new Parameter("output").summary("Output Channel")).description("The name of the output channel of this step.")).format("text")));
            this.output((Channel)((Channel)new Channel("error").summary("Error")).description("Channel used to redirect messages that could not be processed because of an error."));
            this.output((Channel)((Channel)new Channel("ignore").summary("Ignore")).description("Channel used to redirect messages that are ignored voluntarily."));
        }

        <T extends Template> T inputEnabled(boolean bl) {
            this.inputEnabled = bl;
            return (T)this;
        }

        <T extends Template> T outputEnabled(boolean bl) {
            this.outputEnabled = bl;
            return (T)this;
        }

        public List<Channel> inputs() {
            return this.inputs;
        }

        public <T extends Template> T input(Channel channel) {
            if (!this.inputEnabled) {
                throw new UnsupportedOperationException("This template is not input enabled");
            }
            Objects.requireNonNull(channel);
            for (Channel channel2 : this.inputs) {
                if (!channel2.name().equals(channel.name())) continue;
                throw new IllegalArgumentException("Duplicate channel");
            }
            this.inputs.add(channel);
            return (T)this;
        }

        public List<Channel> outputs() {
            return this.outputs;
        }

        public <T extends Template> T output(Channel channel) {
            if (!this.outputEnabled) {
                throw new UnsupportedOperationException("This template is not output enabled");
            }
            Objects.requireNonNull(channel);
            for (Channel channel2 : this.outputs) {
                if (!channel2.name().equals(channel.name())) continue;
                throw new IllegalArgumentException("Duplicate channel");
            }
            this.outputs.add(channel);
            return (T)this;
        }

        public String icon() {
            return this.icon;
        }

        public <T extends Template> T icon(String string) {
            this.icon = string;
            return (T)this;
        }

        public ROLE role() {
            return this.role;
        }

        <T extends Template> T role(ROLE rOLE) {
            this.role = rOLE;
            return (T)this;
        }

        @Override
        public Data export() {
            Data data = Data.map();
            for (Channel object : this.inputs) {
                data.put(object.name(), object.export());
            }
            Data data2 = Data.map();
            for (Channel channel : this.outputs) {
                data2.put(channel.name(), channel.export());
            }
            return super.export().put("icon", this.icon()).put("role", (Object)this.role()).put("inputs", data).put("outputs", data2);
        }
    }

    public static enum ROLE {
        ORIGIN,
        ACTION,
        DESTINATION,
        TOPIC,
        QUEUE;

    }
}

