/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.entity.Message;
import aeonics.entity.Step;
import aeonics.entity.security.User;
import aeonics.manager.Manager;
import aeonics.manager.Security;
import aeonics.template.Channel;
import aeonics.template.Parameter;
import aeonics.template.Relationship;
import aeonics.template.Template;
import aeonics.util.StringUtils;
import aeonics.util.Tuples;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class Topic
extends Step.Action {
    @Override
    protected Class<? extends Type> defaultTarget() {
        return Type.class;
    }

    @Override
    protected Supplier<? extends Type> defaultCreator() {
        return Type::new;
    }

    @Override
    public Step.Template template() {
        return (Step.Template)((Template)((Template)((Template)((Template)((Step.Template)((Step.Template)((Step.Template)super.template().input((Channel)((Channel)new Channel("publish").summary("Publish")).description("Publish a message on this topic."))).output((Channel)((Channel)new Channel("subscribe").summary("Subscribe")).description("Subscriptions on this topic."))).icon("alt_route")).role(Step.ROLE.TOPIC)).summary("Topic")).description("Dispatches messages to subscribed entities.")).add((Relationship)((Relationship)((Relationship)((Relationship)((Relationship)((Relationship)new Relationship("links").category(Step.class)).summary("Next flow step")).description("The next step to send data after processing.")).add((Parameter)((Parameter)((Parameter)new Parameter("input").summary("Input Channel")).description("The name of the input channel of the target step.")).format("text"))).add((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("output").summary("Output Channel")).description("The name of the output channel of this step.")).format("text")).defaultValue("subscribe"))).add((Parameter)((Parameter)((Parameter)((Parameter)new Parameter("binding").summary("Subscription binding key")).description("The subscription key allows to filter the messages that the queue will receive.")).format("text")).optional(true).defaultValue("#")))).cast();
    }

    public static class Type
    extends Step.Action.Type {
        public Type() {
            this.security((type, data, string) -> {
                if (!Manager.of(Security.class).granted(type == null ? User.ANONYMOUS : type, "topic", Data.map().put("message", data).put("topic", this.id()))) {
                    throw new SecurityException("Access denied");
                }
            });
        }

        @Override
        List<Tuples.Tuple<Entity, Data>> collectLinks(String string) {
            if (!string.equals("subscribe")) {
                return super.collectLinks(string);
            }
            ArrayList<Tuples.Tuple<Entity, Data>> arrayList = new ArrayList<Tuples.Tuple<Entity, Data>>();
            for (Tuples.Tuple tuple : this.relations("links")) {
                if (tuple.a == null || !((Data)tuple.b).asString("output").equals(string) || !(tuple.a instanceof Step.Action.Type) && !(tuple.a instanceof Step.Destination.Type) || !StringUtils.simplePathMatches(((Data)tuple.b).asString("binding"), ((Message)this.context().get()).key())) continue;
                arrayList.add(tuple);
            }
            return arrayList;
        }

        @Override
        protected Message process(Message message, String string, String string2) throws Exception {
            message.metadata().put("topic", this.id());
            return message;
        }

        public void publish(Message message) {
            if (message == null) {
                return;
            }
            this.accept(message, "publish");
        }
    }
}

