/*
 * Decompiled with CFR 0.152.
 */
package aeonics.entity.security;

import aeonics.data.Data;
import aeonics.entity.Registry;
import aeonics.entity.security.User;
import aeonics.manager.Manager;
import aeonics.manager.Security;
import aeonics.util.Exportable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Token
implements Exportable {
    protected String value = null;
    protected String user = null;
    protected long epoch = System.currentTimeMillis();
    protected long validity = 3600000L;
    protected Set<String> scopes = new HashSet<String>();

    public Token(User.Type type, String ... stringArray) {
        Objects.requireNonNull(type);
        if (type == User.ANONYMOUS || type == User.SYSTEM) {
            throw new IllegalArgumentException("Invalid user");
        }
        this.user = type.id();
        if (stringArray != null) {
            for (String string : stringArray) {
                this.scopes.add(string);
            }
        }
        this.value = Manager.of(Security.class).randomHash();
    }

    public Token(User.Type type, long l, String ... stringArray) {
        Objects.requireNonNull(type);
        if (type == User.ANONYMOUS || type == User.SYSTEM) {
            throw new IllegalArgumentException("Invalid user");
        }
        this.user = type.id();
        if (stringArray != null) {
            for (String string : stringArray) {
                this.scopes.add(string);
            }
        }
        this.validity = l;
        this.value = Manager.of(Security.class).randomHash();
    }

    public Token(User.Type type, long l, long l2, String ... stringArray) {
        Objects.requireNonNull(type);
        if (type == User.ANONYMOUS || type == User.SYSTEM) {
            throw new IllegalArgumentException("Invalid user");
        }
        this.user = type.id();
        if (stringArray != null) {
            for (String string : stringArray) {
                this.scopes.add(string);
            }
        }
        this.validity = l;
        this.epoch = l2;
        this.value = Manager.of(Security.class).randomHash();
    }

    public Token(User.Type type, long l, long l2, String string, String ... stringArray) {
        Objects.requireNonNull(type);
        if (type == User.ANONYMOUS || type == User.SYSTEM) {
            throw new IllegalArgumentException("Invalid user");
        }
        this.user = type.id();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                this.scopes.add(string2);
            }
        }
        this.validity = l;
        this.epoch = l2;
        this.value = string;
    }

    public Token(Data data) {
        if (data == null || !data.isMap()) {
            throw new IllegalArgumentException("Invalid token data: " + data);
        }
        this.user = data.asString("user");
        if (this.user.equals(User.ANONYMOUS.id()) || this.user.equals(User.SYSTEM.id())) {
            throw new IllegalArgumentException("Invalid user");
        }
        this.validity = data.asLong("validity");
        this.epoch = data.asLong("epoch");
        this.value = data.asString("value");
        for (Data data2 : data.get("scopes")) {
            this.scopes.add(data2.asString());
        }
    }

    public String value() {
        return this.value;
    }

    public User.Type user() {
        return (User.Type)Registry.of(User.class).get(this.user);
    }

    public boolean isFor(String string) {
        return string != null && string.equals(this.user);
    }

    public long notBefore() {
        return this.epoch;
    }

    public long notAfter() {
        return this.validity <= 0L ? Long.MAX_VALUE : this.epoch + this.validity;
    }

    public boolean isValid() {
        if (this.validity <= 0L) {
            return true;
        }
        return this.epoch + this.validity > System.currentTimeMillis();
    }

    public long validity() {
        return this.validity;
    }

    public void reset() {
        this.epoch = System.currentTimeMillis();
    }

    public boolean inScope(String string) {
        return this.scopes.contains(string);
    }

    public void addScope(String string) {
        this.scopes.add(string);
    }

    public void removeScope(String string) {
        this.scopes.remove(string);
    }

    @Override
    public Data export() {
        Data data = Data.list();
        for (String string : this.scopes) {
            data.add((Object)string);
        }
        return Data.map().put("user", this.user).put("value", this.value).put("epoch", this.epoch).put("validity", this.validity).put("scopes", data);
    }
}

