/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager;

import aeonics.data.Data;
import aeonics.manager.Config;
import aeonics.manager.Manager;
import aeonics.util.Callback;
import aeonics.util.Tuples;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class Network
extends Manager.Type {
    @Override
    public final Class<? extends Manager.Type> manager() {
        return Network.class;
    }

    public static Network get() {
        return Manager.of(Network.class);
    }

    public static KeyManager keyManager(final SecurityOptions securityOptions, final boolean bl) {
        return new X509ExtendedKeyManager(){
            private final String alias = "default";
            private final String[] aliases = new String[]{"default"};

            @Override
            public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
                if (sSLEngine.getHandshakeSession() instanceof ExtendedSSLSession) {
                    List<SNIServerName> list = ((ExtendedSSLSession)sSLEngine.getHandshakeSession()).getRequestedServerNames();
                    if (list == null || list.isEmpty()) {
                        return "default";
                    }
                    for (SNIServerName sNIServerName : list) {
                        if (!(sNIServerName instanceof SNIHostName)) continue;
                        return ((SNIHostName)sNIServerName).getAsciiName();
                    }
                }
                return "default";
            }

            @Override
            public X509Certificate[] getCertificateChain(String string) {
                X509Certificate[] x509CertificateArray;
                if (securityOptions != null && bl && (x509CertificateArray = securityOptions.clientCertificate()) != null) {
                    return new X509Certificate[]{(X509Certificate)x509CertificateArray.a};
                }
                if (securityOptions != null && !bl) {
                    Tuples.Tuple<X509Certificate[], PrivateKey> tuple;
                    x509CertificateArray = securityOptions.serverCertificateChain();
                    if (x509CertificateArray != null) {
                        return x509CertificateArray;
                    }
                    Function<String, Tuples.Tuple<X509Certificate[], PrivateKey>> function = securityOptions.serverCertificateSelector();
                    if (function != null && (tuple = function.apply(string == null || string.equals(this.alias) ? null : string)) != null) {
                        return (X509Certificate[])tuple.a;
                    }
                }
                return null;
            }

            @Override
            public PrivateKey getPrivateKey(String string) {
                Tuples.Tuple<X509Certificate, PrivateKey> tuple;
                if (securityOptions != null && bl && (tuple = securityOptions.clientCertificate()) != null) {
                    return (PrivateKey)tuple.b;
                }
                if (securityOptions != null && !bl) {
                    Tuples.Tuple<X509Certificate[], PrivateKey> tuple2;
                    tuple = securityOptions.serverCertificate();
                    if (tuple != null) {
                        return (PrivateKey)tuple.b;
                    }
                    Function<String, Tuples.Tuple<X509Certificate[], PrivateKey>> function = securityOptions.serverCertificateSelector();
                    if (function != null && (tuple2 = function.apply(string == null || string.equals(this.alias) ? null : string)) != null) {
                        return (PrivateKey)tuple2.b;
                    }
                }
                return null;
            }

            @Override
            public String[] getServerAliases(String string, Principal[] principalArray) {
                return this.aliases;
            }

            @Override
            public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
                return "default";
            }

            @Override
            public String[] getClientAliases(String string, Principal[] principalArray) {
                return this.aliases;
            }

            @Override
            public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
                return "default";
            }
        };
    }

    public static TrustManager trustManager(final SecurityOptions securityOptions) {
        return new X509TrustManager(){
            private final X509Certificate[] empty = new X509Certificate[0];

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                if (x509CertificateArray != null && x509CertificateArray.length > 0 && securityOptions != null && securityOptions.clientCertificateVerifier() != null) {
                    try {
                        securityOptions.clientCertificateVerifier().accept(x509CertificateArray[0]);
                    }
                    catch (Exception exception) {
                        throw new CertificateException("Client certificate not trusted");
                    }
                }
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                if (x509CertificateArray != null && x509CertificateArray.length > 0 && securityOptions != null && securityOptions.serverCertificateVerifier() != null) {
                    try {
                        securityOptions.serverCertificateVerifier().accept(x509CertificateArray[0]);
                    }
                    catch (Exception exception) {
                        throw new CertificateException("Server certificate not trusted");
                    }
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return this.empty;
            }
        };
    }

    public static SSLEngine sslEngine(SecurityOptions securityOptions, boolean bl) {
        try {
            SSLEngine sSLEngine = Network.sslContext(securityOptions, bl).createSSLEngine();
            if (securityOptions != null) {
                Object object;
                Iterable<String> iterable;
                SSLParameters sSLParameters = sSLEngine.getSSLParameters();
                List<String> list = securityOptions.protocols();
                if ((list == null || list.isEmpty()) && Manager.of(Config.class).contains(Network.class, "tls.default.protocols")) {
                    iterable = Manager.of(Config.class).get(Network.class, "tls.default.protocols");
                    if (iterable.isList() && !iterable.isEmpty()) {
                        list = new ArrayList<String>(iterable.size());
                        for (Data object2 : iterable) {
                            list.add(object2.asString());
                        }
                    } else {
                        list = null;
                    }
                }
                if (list != null && !list.isEmpty()) {
                    iterable = new LinkedList<String>();
                    Collections.addAll(iterable, sSLEngine.getSupportedProtocols());
                    iterable.retainAll(list);
                    if (!iterable.isEmpty()) {
                        sSLParameters.setProtocols(iterable.toArray((String[])new String[iterable.size()]));
                    }
                }
                if (((iterable = securityOptions.protocols()) == null || iterable.isEmpty()) && Manager.of(Config.class).contains(Network.class, "tls.default.ciphers")) {
                    object = Manager.of(Config.class).get(Network.class, "tls.default.ciphers");
                    if (object.isList() && !object.isEmpty()) {
                        iterable = new ArrayList(object.size());
                        Iterator<Data> iterator = object.iterator();
                        while (iterator.hasNext()) {
                            Data data = iterator.next();
                            iterable.add((String)data.asString());
                        }
                    } else {
                        iterable = null;
                    }
                }
                if (iterable != null && !iterable.isEmpty()) {
                    object = new LinkedList<String>();
                    Collections.addAll(object, sSLEngine.getSupportedCipherSuites());
                    object.retainAll((Collection<?>)iterable);
                    if (!object.isEmpty()) {
                        sSLParameters.setCipherSuites(object.toArray(new String[object.size()]));
                    }
                }
                if (securityOptions.alpn() != null) {
                    object = securityOptions.alpn();
                    sSLParameters.setApplicationProtocols(object.toArray(new String[object.size()]));
                }
                if (!bl && securityOptions.clientCertificateVerifier() != null) {
                    sSLEngine.setNeedClientAuth(true);
                }
                sSLEngine.setSSLParameters(sSLParameters);
            }
            sSLEngine.setUseClientMode(bl);
            return sSLEngine;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static SSLContext sslContext(SecurityOptions securityOptions, boolean bl) {
        try {
            KeyManager[] keyManagerArray = new KeyManager[]{Network.keyManager(securityOptions, bl)};
            TrustManager[] trustManagerArray = new TrustManager[]{Network.trustManager(securityOptions)};
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(keyManagerArray, trustManagerArray, SecureRandom.getInstanceStrong());
            return sSLContext;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public abstract Connection securize(Connection var1, SecurityOptions var2);

    public Connection client(String string, int n) throws IOException {
        return this.client(string, n, null);
    }

    public abstract Connection client(String var1, int var2, SecurityOptions var3) throws IOException;

    public Server server(String string, int n) throws IOException {
        return this.server(string, n, null);
    }

    public abstract Server server(String var1, int var2, SecurityOptions var3) throws IOException;

    public abstract void refresh();

    public static interface Server
    extends Closeable {
        public Callback<Connection, Server> onAccept();

        public Callback<Void, Server> onClose();

        public boolean isSecure();
    }

    public static interface Connection
    extends Closeable,
    Iterable<byte[]>,
    Iterator<byte[]> {
        public boolean isSecure();

        public boolean isClientMode();

        default public boolean isServerMode() {
            return !this.isClientMode();
        }

        public Callback<Void, Connection> onReady();

        @Override
        public byte[] next();

        @Override
        public boolean hasNext();

        @Override
        default public Iterator<byte[]> iterator() {
            return this;
        }

        default public void write(byte[] byArray) throws IOException {
            this.write(ByteBuffer.wrap(byArray));
        }

        default public void write(String string) throws IOException {
            this.write(ByteBuffer.wrap(string.getBytes(StandardCharsets.ISO_8859_1)));
        }

        default public void write(Data data) throws IOException {
            this.write(ByteBuffer.wrap(data.toString().getBytes(StandardCharsets.ISO_8859_1)));
        }

        public void write(ByteBuffer var1);

        public Callback<Void, Connection> onClose();

        public void timeout(long var1);

        public String clientIp();

        public String serverIp();

        public String alpn();

        public String sni();

        public boolean active();
    }

    public static class SecurityOptions {
        private Tuples.Tuple<X509Certificate, PrivateKey> clientCertificate = null;
        private Tuples.Tuple<X509Certificate, PrivateKey> serverCertificate = null;
        private X509Certificate[] serverCertificateChain = null;
        private Function<String, Tuples.Tuple<X509Certificate[], PrivateKey>> serverCertificateSelector = null;
        private Consumer<X509Certificate> clientCertificateVerifier = null;
        private Consumer<X509Certificate> serverCertificateVerifier = null;
        private List<String> ciphers = null;
        private List<String> protocols = null;
        private List<String> alpn = null;

        public static X509Certificate certificate(String string) throws Exception {
            X509Certificate[] x509CertificateArray = SecurityOptions.certificates(string);
            if (x509CertificateArray.length > 0) {
                return x509CertificateArray[0];
            }
            throw new IllegalArgumentException("Empty certificate");
        }

        public static X509Certificate[] certificates(String string) throws Exception {
            if (string == null || string.isBlank()) {
                throw new IllegalArgumentException("Empty certificate");
            }
            InputStream inputStream = null;
            if (string.startsWith("storage://")) {
                inputStream = URI.create(string).toURL().openConnection().getInputStream();
            } else if (string.startsWith("-----BEGIN ")) {
                inputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.ISO_8859_1));
            } else if (Files.isRegularFile(Paths.get(string, new String[0]), new LinkOption[0])) {
                inputStream = new ByteArrayInputStream(Files.readAllBytes(Paths.get(string, new String[0])));
            } else {
                throw new IllegalArgumentException("Invalid certificate");
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Object[] objectArray = certificateFactory.generateCertificates(inputStream).toArray();
            if (objectArray.length == 0) {
                throw new IllegalArgumentException("Invalid certificate");
            }
            X509Certificate[] x509CertificateArray = new X509Certificate[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                x509CertificateArray[i] = (X509Certificate)objectArray[i];
            }
            return x509CertificateArray;
        }

        public static PrivateKey privateKey(X509Certificate x509Certificate, String string) throws Exception {
            String string2 = null;
            if (string.startsWith("storage://")) {
                string2 = new String(URI.create(string).toURL().openConnection().getInputStream().readAllBytes(), StandardCharsets.ISO_8859_1);
            } else if (string.startsWith("-----BEGIN ")) {
                string2 = string;
            } else if (Files.isRegularFile(Paths.get(string, new String[0]), new LinkOption[0])) {
                string2 = new String(Files.readAllBytes(Paths.get(string, new String[0])), StandardCharsets.ISO_8859_1);
            } else {
                throw new IllegalArgumentException("Invalid key");
            }
            string2 = string2.replaceAll("\\s", "").replaceFirst(".*?-+[A-Z ]+-+", "").replaceFirst("-+[A-Z ]+-+.*$", "");
            byte[] byArray = Base64.getDecoder().decode(string2);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance(x509Certificate.getPublicKey().getAlgorithm());
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            return privateKey;
        }

        public SecurityOptions withClientCertificate(String string, String string2) throws Exception {
            if (string == null || string2 == null) {
                this.serverCertificate = null;
                return this;
            }
            X509Certificate x509Certificate = SecurityOptions.certificate(string);
            PrivateKey privateKey = SecurityOptions.privateKey(x509Certificate, string2);
            return this.withClientCertificate(x509Certificate, privateKey);
        }

        public SecurityOptions withClientCertificate(X509Certificate x509Certificate, PrivateKey privateKey) {
            this.clientCertificate = x509Certificate == null || privateKey == null ? null : new Tuples.Tuple<X509Certificate, PrivateKey>(x509Certificate, privateKey);
            return this;
        }

        public Tuples.Tuple<X509Certificate, PrivateKey> clientCertificate() {
            return this.clientCertificate;
        }

        public SecurityOptions withServerCertificate(X509Certificate x509Certificate, PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
            this.serverCertificate = x509Certificate == null || privateKey == null ? null : new Tuples.Tuple<X509Certificate, PrivateKey>(x509Certificate, privateKey);
            if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                this.serverCertificateChain = new X509Certificate[]{x509Certificate};
            } else if (!x509CertificateArray[0].equals(x509Certificate)) {
                this.serverCertificateChain = new X509Certificate[x509CertificateArray.length + 1];
                this.serverCertificateChain[0] = x509Certificate;
                System.arraycopy(x509CertificateArray, 0, this.serverCertificateChain, 1, x509CertificateArray.length);
            } else {
                this.serverCertificateChain = x509CertificateArray;
            }
            return this;
        }

        public SecurityOptions withServerCertificate(String string, String string2, String string3) throws Exception {
            Object object;
            if (string == null || string2 == null) {
                this.serverCertificate = null;
                return this;
            }
            InputStream inputStream = null;
            if (string.startsWith("storage://")) {
                inputStream = URI.create(string).toURL().openConnection().getInputStream();
            } else if (string.startsWith("-----BEGIN ")) {
                inputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.ISO_8859_1));
            } else if (Files.isRegularFile(Paths.get(string, new String[0]), new LinkOption[0])) {
                inputStream = new ByteArrayInputStream(Files.readAllBytes(Paths.get(string, new String[0])));
            } else {
                throw new IllegalArgumentException("Invalid certificate");
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Object[] objectArray = certificateFactory.generateCertificates(inputStream).toArray();
            if (objectArray.length == 0) {
                throw new IllegalArgumentException("Invalid certificate");
            }
            X509Certificate[] x509CertificateArray = new X509Certificate[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                x509CertificateArray[i] = (X509Certificate)objectArray[i];
            }
            X509Certificate x509Certificate = x509CertificateArray[0];
            X509Certificate[] x509CertificateArray2 = x509CertificateArray;
            if (string3 != null) {
                object = null;
                if (string3.startsWith("storage://")) {
                    object = URI.create(string3).toURL().openConnection().getInputStream();
                } else if (string3.startsWith("-----BEGIN ")) {
                    object = new ByteArrayInputStream(string3.getBytes(StandardCharsets.ISO_8859_1));
                } else if (Files.isRegularFile(Paths.get(string3, new String[0]), new LinkOption[0])) {
                    object = new ByteArrayInputStream(Files.readAllBytes(Paths.get(string3, new String[0])));
                } else {
                    throw new IllegalArgumentException("Invalid certificate");
                }
                objectArray = certificateFactory.generateCertificates((InputStream)object).toArray();
                if (objectArray.length > 0) {
                    int n = 0;
                    if (!x509Certificate.equals((X509Certificate)objectArray[0])) {
                        x509CertificateArray2 = new X509Certificate[objectArray.length + 1];
                        n = 1;
                        x509CertificateArray2[0] = x509Certificate;
                    } else {
                        x509CertificateArray2 = new X509Certificate[objectArray.length];
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        x509CertificateArray2[i + n] = (X509Certificate)objectArray[i];
                    }
                }
            }
            object = SecurityOptions.privateKey(x509Certificate, string2);
            return this.withServerCertificate(x509Certificate, (PrivateKey)object, x509CertificateArray2);
        }

        public Tuples.Tuple<X509Certificate, PrivateKey> serverCertificate() {
            return this.serverCertificate;
        }

        public X509Certificate[] serverCertificateChain() {
            return this.serverCertificateChain;
        }

        public SecurityOptions withServerCertificate(Function<String, Tuples.Tuple<X509Certificate[], PrivateKey>> function) {
            this.serverCertificateSelector = function;
            return this;
        }

        public Function<String, Tuples.Tuple<X509Certificate[], PrivateKey>> serverCertificateSelector() {
            return this.serverCertificateSelector;
        }

        public SecurityOptions withClientVerifier(Consumer<X509Certificate> consumer) {
            this.clientCertificateVerifier = consumer;
            return this;
        }

        public Consumer<X509Certificate> clientCertificateVerifier() {
            return this.clientCertificateVerifier;
        }

        public SecurityOptions withServerVerifier(Consumer<X509Certificate> consumer) {
            this.serverCertificateVerifier = consumer;
            return this;
        }

        public Consumer<X509Certificate> serverCertificateVerifier() {
            return this.serverCertificateVerifier;
        }

        public SecurityOptions withCiphers(List<String> list) {
            this.ciphers = list;
            return this;
        }

        public List<String> ciphers() {
            return this.ciphers;
        }

        public SecurityOptions withProtocols(List<String> list) {
            this.protocols = list;
            return this;
        }

        public List<String> protocols() {
            return this.protocols;
        }

        public SecurityOptions withAlpn(List<String> list) {
            this.alpn = list;
            return this;
        }

        public List<String> alpn() {
            return this.alpn;
        }
    }
}

