/*
 * Decompiled with CFR 0.152.
 */
package aeonics.template;

import aeonics.data.Data;
import aeonics.entity.Entity;
import aeonics.template.Item;
import aeonics.template.Template;
import aeonics.util.StringUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Factory<T extends Entity>
implements Iterable<Template<T>> {
    private static Map<String, Factory<? extends Entity>> factories = new ConcurrentHashMap<String, Factory<? extends Entity>>();
    private String category = null;
    private ConcurrentHashMap<String, Template<T>> templates = new ConcurrentHashMap();

    public static <U extends Entity> Factory<U> of(Class<? extends Item<? super U>> clazz) {
        return Factory.of(StringUtils.toLowerCase(clazz));
    }

    public static <U extends Entity> Factory<U> of(String string2) {
        string2 = StringUtils.toLowerCase(string2);
        factories.computeIfAbsent(string2, string -> new Factory((String)string));
        return factories.get(string2);
    }

    public static <U extends Entity> Template<U> of(Entity entity) {
        Factory<U> factory = Factory.of(entity.category());
        return factory.get(entity.type());
    }

    public static boolean has(String string) {
        string = StringUtils.toLowerCase(string);
        return factories.containsKey(string);
    }

    public static <U extends Entity> Template<U> add(Template<U> template) {
        if (template == null) {
            return null;
        }
        return Factory.of(template.category()).put(template);
    }

    public static <U extends Entity> Template<? extends U> add(Item<U> item) {
        if (item == null) {
            return null;
        }
        return Factory.add(item.template());
    }

    public static <U extends Entity> U create(Data data) {
        if (data == null || data.isEmpty("type") || data.isEmpty("category")) {
            throw new IllegalArgumentException("Invalid input data");
        }
        Template<U> template = Factory.of(data.asString("category")).get(data.asString("type"));
        if (template == null) {
            throw new RuntimeException("No template found for " + data.asString("category") + " > " + data.asString("type"));
        }
        return template.create(data);
    }

    public static <U extends Entity, V extends Item<? super U>> U create(Class<? extends Item<? super U>> clazz, Class<V> clazz2, Data data) {
        if (clazz == null || clazz2 == null) {
            throw new IllegalArgumentException("Invalid input data");
        }
        Template<U> template = Factory.of(clazz).get(clazz2);
        if (template == null) {
            throw new RuntimeException("No template found for " + StringUtils.toLowerCase(clazz) + " > " + StringUtils.toLowerCase(clazz2));
        }
        return template.create(data);
    }

    public static <U extends Entity> U update(U u, Data data) {
        Template<U> template = Factory.of(u.category()).get(u.type());
        if (template == null) {
            throw new RuntimeException("No template found for " + u.category() + " > " + u.type());
        }
        return template.update(data, u);
    }

    public static Iterable<Factory<?>> all() {
        return factories.values();
    }

    private Factory(String string) {
        this.category = StringUtils.toLowerCase(string);
    }

    public String category() {
        return this.category;
    }

    public <U extends T, V extends Item<? super T>> Template<U> get(Class<V> clazz) {
        return this.get(StringUtils.toLowerCase(clazz));
    }

    public <U extends T> Template<U> get(String string) {
        return this.templates.get(StringUtils.toLowerCase(string));
    }

    public <V extends Item<? super T>> boolean contains(Class<V> clazz) {
        return this.contains(StringUtils.toLowerCase(clazz));
    }

    public boolean contains(String string) {
        return this.templates.containsKey(StringUtils.toLowerCase(string));
    }

    public <U extends T> Template<U> put(Template<U> template) {
        if (template == null) {
            throw new IllegalArgumentException("Cannot register a null template");
        }
        if (!template.category().equals(this.category())) {
            throw new IllegalArgumentException("Template category mismatch");
        }
        this.templates.put(StringUtils.toLowerCase(template.type()), template);
        return template;
    }

    public <U extends T, V extends Item<? super T>> Template<U> remove(Class<V> clazz) {
        return this.remove(StringUtils.toLowerCase(clazz));
    }

    public <U extends T> Template<U> remove(String string) {
        return this.templates.remove(StringUtils.toLowerCase(string));
    }

    public void clear() {
        this.templates.clear();
    }

    public int size() {
        return this.templates.size();
    }

    public Collection<Template<T>> filter(Predicate<Template<T>> predicate) {
        return this.templates.values().stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    public Iterator<Template<T>> iterator() {
        return this.templates.values().iterator();
    }
}

