/*
 * Decompiled with CFR 0.152.
 */
package aeonics.util;

import aeonics.data.Data;
import aeonics.util.Exportable;
import aeonics.util.StringUtils;
import java.util.HashMap;

public class Json {
    private Json() {
    }

    public static String encode(Object object) {
        return Json.encode(Data.of(object));
    }

    public static String encode(Exportable exportable) {
        return exportable == null ? "null" : Json.encode(exportable.export());
    }

    public static String encode(Data data) {
        return data == null ? "null" : data.toString();
    }

    public static String escape(String string) {
        char c;
        int n;
        if (string == null) {
            return null;
        }
        for (n = 0; n < string.length() && (c = string.charAt(n)) >= '2' && c <= '~' && c != '\\'; ++n) {
        }
        if (n == string.length()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(string, 0, n);
        boolean bl = false;
        while (n < string.length()) {
            int n2;
            int n3 = string.codePointAt(n);
            if (Character.isSupplementaryCodePoint(n3)) {
                String string2 = "0000" + Integer.toString(Character.highSurrogate(n3), 16);
                stringBuilder.append("\\u");
                for (n2 = 4; n2 > 0; --n2) {
                    stringBuilder.append(string2.charAt(string2.length() - n2));
                }
                string2 = "0000" + Integer.toString(Character.lowSurrogate(n3), 16);
                stringBuilder.append("\\u");
                for (n2 = 4; n2 > 0; --n2) {
                    stringBuilder.append(string2.charAt(string2.length() - n2));
                }
                ++n;
            } else {
                switch (n3) {
                    case 34: 
                    case 92: {
                        stringBuilder.append('\\');
                        stringBuilder.appendCodePoint(n3);
                        break;
                    }
                    case 8: {
                        stringBuilder.append("\\b");
                        bl = true;
                        break;
                    }
                    case 12: {
                        stringBuilder.append("\\f");
                        bl = true;
                        break;
                    }
                    case 10: {
                        stringBuilder.append("\\n");
                        break;
                    }
                    case 13: {
                        stringBuilder.append("\\r");
                        break;
                    }
                    case 9: {
                        stringBuilder.append("\\t");
                        break;
                    }
                    default: {
                        if (bl || n3 <= 31 || n3 == 127 || n3 >= 245 || n3 == 192 || n3 == 193 || n3 >= 128 && n3 <= 191) {
                            String string3 = "0000" + Integer.toString(n3, 16);
                            stringBuilder.append("\\u");
                            for (n2 = 4; n2 > 0; --n2) {
                                stringBuilder.append(string3.charAt(string3.length() - n2));
                            }
                            bl = true;
                            break;
                        }
                        if (n3 <= 126) {
                            stringBuilder.appendCodePoint(n3);
                            break;
                        }
                        int n4 = 0;
                        n2 = 0;
                        if ((n3 & 0xF8) == 240) {
                            n4 = 3;
                            n2 = n3 & 7;
                        } else if ((n3 & 0xF0) == 224) {
                            n4 = 2;
                            n2 = n3 & 0xF;
                        } else if ((n3 & 0xE0) == 192) {
                            n4 = 1;
                            n2 = n3 & 0x1F;
                        } else {
                            String string4 = "0000" + Integer.toString(n3, 16);
                            stringBuilder.append("\\u");
                            for (int i = 4; i > 0; --i) {
                                stringBuilder.append(string4.charAt(string4.length() - i));
                            }
                            bl = true;
                            break;
                        }
                        if (n + n4 >= string.length()) {
                            String string5 = "0000" + Integer.toString(n3, 16);
                            stringBuilder.append("\\u");
                            for (int i = 4; i > 0; --i) {
                                stringBuilder.append(string5.charAt(string5.length() - i));
                            }
                        } else {
                            int n5;
                            boolean bl2 = true;
                            for (int i = 1; i <= n4 && i + n < string.length(); ++i) {
                                n3 = string.codePointAt(n + i);
                                if (n3 < 128 || n3 > 191) {
                                    bl2 = false;
                                }
                                n2 <<= 6;
                                n2 |= n3 & 0x3F;
                            }
                            if (!bl2) {
                                n2 = string.codePointAt(n);
                            } else {
                                n += n4;
                            }
                            if (n2 > 65535) {
                                String string6 = "0000" + Integer.toString(0xD800 | (n2 -= 65536) >> 10 & 0x3FF, 16);
                                stringBuilder.append("\\u");
                                for (n5 = 4; n5 > 0; --n5) {
                                    stringBuilder.append(string6.charAt(string6.length() - n5));
                                }
                                string6 = "0000" + Integer.toString(0xDC00 | n2 & 0x3FF, 16);
                                stringBuilder.append("\\u");
                                for (n5 = 4; n5 > 0; --n5) {
                                    stringBuilder.append(string6.charAt(string6.length() - n5));
                                }
                            } else {
                                String string7 = "0000" + Integer.toString(n2, 16);
                                stringBuilder.append("\\u");
                                for (n5 = 4; n5 > 0; --n5) {
                                    stringBuilder.append(string7.charAt(string7.length() - n5));
                                }
                            }
                        }
                    }
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String unescape(String string) {
        if (string == null) {
            return string;
        }
        if (string.indexOf(92) < 0) {
            return string;
        }
        char[] cArray = new char[string.length()];
        int n = 0;
        char c = '\u0000';
        for (int i = 0; i < cArray.length; ++i) {
            c = string.charAt(i);
            if (c == '\\') {
                if (++i >= cArray.length) {
                    cArray[n++] = c;
                    break;
                }
                c = string.charAt(i);
                switch (c) {
                    case '\\': {
                        cArray[n++] = 92;
                        break;
                    }
                    case 'n': {
                        cArray[n++] = 10;
                        break;
                    }
                    case 'r': {
                        cArray[n++] = 13;
                        break;
                    }
                    case 't': {
                        cArray[n++] = 9;
                        break;
                    }
                    case 'f': {
                        cArray[n++] = 12;
                        break;
                    }
                    case 'b': {
                        cArray[n++] = 8;
                        break;
                    }
                    case '\"': {
                        cArray[n++] = 34;
                        break;
                    }
                    case '\'': {
                        cArray[n++] = 39;
                        break;
                    }
                    case '/': {
                        cArray[n++] = 47;
                        break;
                    }
                    case 'u': {
                        try {
                            if (cArray.length - i >= 4) {
                                char c2 = (char)Integer.parseInt(string.substring(i + 1, i + 5), 16);
                                cArray[n++] = c2;
                                i += 4;
                                break;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    default: {
                        cArray[n++] = 92;
                        cArray[n++] = c;
                        break;
                    }
                }
                continue;
            }
            cArray[n++] = c;
        }
        return new String(cArray, 0, n);
    }

    public static Data decode(String string) {
        return Decoder.parse(string, new Decoder.State());
    }

    private static class Decoder {
        private Decoder() {
        }

        private static Data parse(String string, State state) {
            state.length = string.length();
            while (true) {
                switch (Decoder.whatIsNext(string, state)) {
                    case ARRAY: {
                        return Decoder.parseArray(string, state);
                    }
                    case MAP: {
                        return Decoder.parseMap(string, state);
                    }
                    case END: {
                        return Data.of(string);
                    }
                    case UNQUOTED: {
                        return Data.of(Decoder.rawValueFromUnquoted(Decoder.parseUnQuoted(string, state)));
                    }
                    case SINGLEQUOTED: {
                        return Data.of(Decoder.parseSingleQuoted(string, state));
                    }
                    case DOUBLEQUOTED: {
                        return Data.of(Decoder.parseDoubleQuoted(string, state));
                    }
                    case EOF: {
                        return Data.empty();
                    }
                    case COMMENTBLOCK: {
                        Decoder.skipCommentBlock(string, state);
                        break;
                    }
                    case COMMENTLINE: {
                        Decoder.skipCommentLine(string, state);
                    }
                }
            }
        }

        private static Mode whatIsNext(String string, State state) {
            char c = '\u0000';
            while (state.i < state.length && ((c = string.charAt(state.i)) == ' ' || c == '\t' || c == '\r' || c == '\n' || c == ',' || c == ':')) {
                ++state.i;
            }
            if (state.i >= state.length) {
                return Mode.EOF;
            }
            switch (c) {
                case '\'': {
                    state.mark = ++state.i;
                    return Mode.SINGLEQUOTED;
                }
                case '\"': {
                    state.mark = ++state.i;
                    return Mode.DOUBLEQUOTED;
                }
                case '(': 
                case '[': {
                    state.mark = ++state.i;
                    return Mode.ARRAY;
                }
                case '{': {
                    state.mark = ++state.i;
                    return Mode.MAP;
                }
                case ')': 
                case ']': 
                case '}': {
                    state.mark = ++state.i;
                    return Mode.END;
                }
                case '/': {
                    if (state.i >= state.length - 1) break;
                    c = string.charAt(state.i + 1);
                    if (c == '/') {
                        state.i += 2;
                        return Mode.COMMENTLINE;
                    }
                    if (c != '*') break;
                    state.i += 2;
                    return Mode.COMMENTBLOCK;
                }
            }
            state.mark = state.i;
            return Mode.UNQUOTED;
        }

        private static String parseSingleQuoted(String string, State state) {
            char c = '\u0000';
            boolean bl = false;
            while (state.i < state.length) {
                c = string.charAt(state.i);
                if (c == '\\' && state.i + 1 < state.length) {
                    bl = true;
                    ++state.i;
                } else if (c == '\'') {
                    String string2 = string.substring(state.mark, state.i);
                    state.mark = ++state.i;
                    return bl ? Json.unescape(string2) : string2;
                }
                ++state.i;
            }
            String string3 = string.substring(state.mark, state.i);
            state.mark = ++state.i;
            return bl ? Json.unescape(string3) : string3;
        }

        private static String parseDoubleQuoted(String string, State state) {
            char c = '\u0000';
            boolean bl = false;
            while (state.i < state.length) {
                c = string.charAt(state.i);
                if (c == '\\' && state.i + 1 < state.length) {
                    bl = true;
                    ++state.i;
                } else if (c == '\"') {
                    String string2 = string.substring(state.mark, state.i);
                    state.mark = ++state.i;
                    return bl ? Json.unescape(string2) : string2;
                }
                ++state.i;
            }
            String string3 = string.substring(state.mark, state.i);
            state.mark = ++state.i;
            return bl ? Json.unescape(string3) : string3;
        }

        private static String parseUnQuoted(String string, State state) {
            char c = '\u0000';
            boolean bl = false;
            while (state.i < state.length) {
                c = string.charAt(state.i);
                if (c == '\\' && state.i + 1 < state.length) {
                    bl = true;
                    ++state.i;
                } else if (c == ' ' || c == '{' || c == '}' || c == '[' || c == ']' || c == ',' || c == ';' || c == ':' || c == '=' || c == '\t' || c == '\r' || c == '\n') {
                    String string2 = string.substring(state.mark, state.i);
                    if (bl) {
                        return Json.unescape(string2);
                    }
                    if (string2.length() == 4 && string2.equals("null")) {
                        return null;
                    }
                    return string2;
                }
                ++state.i;
            }
            String string3 = string.substring(state.mark, state.i);
            if (bl) {
                return Json.unescape(string3);
            }
            return string3;
        }

        private static Object rawValueFromUnquoted(String string) {
            if (string == null) {
                return null;
            }
            if (string.length() == 4 && string.equals("null")) {
                return null;
            }
            if (string.length() == 5 && string.equals("false")) {
                return false;
            }
            if (string.length() == 4 && string.equals("true")) {
                return true;
            }
            if (StringUtils.isInteger(string)) {
                return Long.parseLong(string);
            }
            if (StringUtils.isFloatingPoint(string)) {
                return Double.parseDouble(string);
            }
            return string;
        }

        private static Data parseMap(String string, State state) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            String string2 = null;
            while (true) {
                Mode mode = Decoder.whatIsNext(string, state);
                switch (mode) {
                    case EOF: {
                        if (string2 != null) {
                            hashMap.put(string2, null);
                        }
                    }
                    case END: {
                        return Data.of(hashMap);
                    }
                    case ARRAY: {
                        if (string2 == null) {
                            throw new IllegalArgumentException("Array cannot be used as Object key");
                        }
                        hashMap.put(string2, Decoder.parseArray(string, state));
                        string2 = null;
                        break;
                    }
                    case MAP: {
                        if (string2 == null) {
                            throw new IllegalArgumentException("Object cannot be used as Object key");
                        }
                        hashMap.put(string2, Decoder.parseMap(string, state));
                        string2 = null;
                        break;
                    }
                    case UNQUOTED: {
                        if (string2 == null) {
                            string2 = Decoder.parseUnQuoted(string, state);
                            break;
                        }
                        hashMap.put(string2, Decoder.rawValueFromUnquoted(Decoder.parseUnQuoted(string, state)));
                        string2 = null;
                        break;
                    }
                    case SINGLEQUOTED: {
                        if (string2 == null) {
                            string2 = Decoder.parseSingleQuoted(string, state);
                            break;
                        }
                        hashMap.put(string2, Decoder.parseSingleQuoted(string, state));
                        string2 = null;
                        break;
                    }
                    case DOUBLEQUOTED: {
                        if (string2 == null) {
                            string2 = Decoder.parseDoubleQuoted(string, state);
                            break;
                        }
                        hashMap.put(string2, Decoder.parseDoubleQuoted(string, state));
                        string2 = null;
                        break;
                    }
                    case COMMENTBLOCK: {
                        Decoder.skipCommentBlock(string, state);
                        break;
                    }
                    case COMMENTLINE: {
                        Decoder.skipCommentLine(string, state);
                    }
                }
            }
        }

        private static Data parseArray(String string, State state) {
            Data data = Data.list();
            while (true) {
                Mode mode = Decoder.whatIsNext(string, state);
                switch (mode) {
                    case END: 
                    case EOF: {
                        return data;
                    }
                    case ARRAY: {
                        data.add((Object)Decoder.parseArray(string, state));
                        break;
                    }
                    case MAP: {
                        data.add((Object)Decoder.parseMap(string, state));
                        break;
                    }
                    case UNQUOTED: {
                        data.add(Decoder.rawValueFromUnquoted(Decoder.parseUnQuoted(string, state)));
                        break;
                    }
                    case SINGLEQUOTED: {
                        data.add((Object)Decoder.parseSingleQuoted(string, state));
                        break;
                    }
                    case DOUBLEQUOTED: {
                        data.add((Object)Decoder.parseDoubleQuoted(string, state));
                        break;
                    }
                    case COMMENTBLOCK: {
                        Decoder.skipCommentBlock(string, state);
                        break;
                    }
                    case COMMENTLINE: {
                        Decoder.skipCommentLine(string, state);
                    }
                }
            }
        }

        private static void skipCommentBlock(String string, State state) {
            char c = '\u0000';
            while (state.i < state.length - 1) {
                c = string.charAt(state.i);
                if (c == '*' && (c = string.charAt(++state.i)) == '/') {
                    ++state.i;
                    return;
                }
                ++state.i;
            }
        }

        private static void skipCommentLine(String string, State state) {
            char c = '\u0000';
            while (state.i < state.length) {
                c = string.charAt(state.i);
                if (c == '\r' || c == '\n') {
                    ++state.i;
                    return;
                }
                ++state.i;
            }
        }

        private static enum Mode {
            ARRAY,
            MAP,
            END,
            UNQUOTED,
            DOUBLEQUOTED,
            SINGLEQUOTED,
            EOF,
            COMMENTBLOCK,
            COMMENTLINE;

        }

        private static class State {
            int mark;
            int i;
            int length = 0;

            private State() {
            }
        }
    }
}

