/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager.impl;

import aeonics.data.Data;
import aeonics.entity.Message;
import aeonics.entity.Step;
import aeonics.entity.security.User;
import aeonics.manager.Config;
import aeonics.manager.Executor;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.template.Channel;
import aeonics.template.Parameter;
import aeonics.template.Template;
import aeonics.util.Snapshotable;
import java.util.function.Supplier;

public class DefaultLogger
extends Manager<Logger> {
    private static final _Logger origin = (_Logger)((Step.Type)((Step.Template)new Step.Origin(){}.target(_Logger.class).creator(() -> new _Logger()).template().cast()).output(new Channel("data").summary("Logs").description("Log entries")).icon("description").summary("Logger").description("This data origin is the source for all log entries that are handled by the logger manager.").create(Data.map().put("id", (Object)"10000000-1500000000000000"))).name("Logger").internal(true).snapshotMode(Snapshotable.SnapshotMode.UPDATE).cast();

    public static void register() {
    }

    public static Step.Origin.Type origin() {
        return origin;
    }

    protected Class<? extends Implementation> defaultTarget() {
        return Implementation.class;
    }

    protected Supplier<? extends Implementation> defaultCreator() {
        return Implementation::new;
    }

    public Template<? extends Logger> template() {
        return super.template().summary("Data logger").description("Emit all logs as an origin step so that it can be managed like a data stream.").config(Logger.class, new Parameter("level").summary("The log level").description("The log level is a number between 0 (log everything) and 1000 (log only critical errors). Only the logs with a level above thedefined value will actually be logged, others will be ignored.").rule(Parameter.Rule.INTEGER).format("number").optional(true).defaultValue((Object)700));
    }

    private static class Implementation
    extends Logger {
        public Implementation() {
            this.level = Logger.CONSOLE.level();
        }

        public void handle(int n, String string, String string2, Object ... objectArray) {
            if (n < this.level() || string2 == null || string2.isBlank()) {
                return;
            }
            Runnable runnable = () -> {
                Message message = new Message(n + "/" + string).user(User.SYSTEM.id()).content(Data.map().put("date", (Object)System.currentTimeMillis()).put("level", (Object)n).put("type", (Object)string).put("message", (Object)this.bindMessage(string2, objectArray)));
                origin.produce(message, "data");
            };
            if (Manager.of(Executor.class) != null && !((Executor)Manager.of(Executor.class)).isNormal()) {
                ((Executor)Manager.of(Executor.class)).normal(() -> runnable.run());
            } else {
                runnable.run();
            }
        }

        public void config(String string, Data data) {
            if (Config.implodeName(Logger.class, (String)"level").equals(string)) {
                try {
                    this.level(data.asInt());
                }
                catch (Exception exception) {
                    this.log(1000, Logger.class, "Could not set log level to {}. Current value {} is unchanged.", new Object[]{data, this.level()});
                }
            }
        }
    }

    private static final class _Logger
    extends Step.Origin.Type {
        private _Logger() {
        }

        public void produce(Message message, String string) {
            if (message == null) {
                return;
            }
            if (!this.started()) {
                this.start();
            }
            super.produce(message, string);
        }
    }
}

