/*
 * Decompiled with CFR 0.152.
 */
package aeonics.manager.impl;

import aeonics.data.Data;
import aeonics.entity.Registry;
import aeonics.entity.Step;
import aeonics.manager.Executor;
import aeonics.manager.Lifecycle;
import aeonics.manager.Logger;
import aeonics.manager.Manager;
import aeonics.manager.Scheduler;
import aeonics.template.Template;
import aeonics.util.Callback;
import aeonics.util.Snapshotable;
import aeonics.util.Tuples;
import java.io.Closeable;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class DefaultScheduler
extends Manager<Scheduler> {
    private static Queue<Tuples.Tuple<ZonedDateTime, Consumer<ZonedDateTime>>> once = new ConcurrentLinkedQueue<Tuples.Tuple<ZonedDateTime, Consumer<ZonedDateTime>>>();
    private static final Object locker = new Object();
    private static final Step.Origin.Background origin = ((Step.Origin.Background)((Step.Type)new Step.Origin(){}.target(Step.Origin.Background.class).creator(Step.Origin.Background::new).template().summary("Scheduler data origin").description("This data origin is used by the Scheduler to inject messages in the system.").create(Data.map().put("id", (Object)"10000000-1700000000000000"))).internal(true).snapshotMode(Snapshotable.SnapshotMode.UPDATE).name("Scheduler").cast()).run(() -> {
        Thread.currentThread().setName(Thread.currentThread().getName() + " :: Scheduler Manager");
        while (true) {
            Object object2;
            ZonedDateTime zonedDateTime = ZonedDateTime.now().withNano(0);
            ChronoZonedDateTime chronoZonedDateTime = null;
            for (Object object2 : Registry.of(Scheduler.Cron.class)) {
                ZonedDateTime zonedDateTime2;
                if (object2 == null || (zonedDateTime2 = object2.next(false)) == null) continue;
                if (zonedDateTime2.isEqual(zonedDateTime) || zonedDateTime2.isBefore(zonedDateTime)) {
                    ((Logger)Manager.of(Logger.class)).finest(Scheduler.class, "Task {} ({}) is executed now", new Object[]{object2.id(), object2.name()});
                    ((Executor)Manager.of(Executor.class)).normal(() -> DefaultScheduler.lambda$static$0((Scheduler.Cron.Type)object2, zonedDateTime));
                    zonedDateTime2 = object2.next(true);
                } else {
                    ((Logger)Manager.of(Logger.class)).finest(Scheduler.class, "Task {} ({}) is scheduled for {}", new Object[]{object2.id(), object2.name(), zonedDateTime2});
                }
                if (chronoZonedDateTime != null && (zonedDateTime2 == null || !zonedDateTime2.isBefore(chronoZonedDateTime))) continue;
                chronoZonedDateTime = zonedDateTime2;
            }
            Iterator iterator = once.iterator();
            while (iterator.hasNext()) {
                object2 = (Tuples.Tuple)iterator.next();
                if (((ZonedDateTime)object2.a).isEqual(zonedDateTime) || ((ZonedDateTime)object2.a).isBefore(zonedDateTime)) {
                    ((Logger)Manager.of(Logger.class)).finest(Scheduler.class, (Object)"One shot task is executed now");
                    ((Executor)Manager.of(Executor.class)).normal(() -> DefaultScheduler.lambda$static$1((Tuples.Tuple)object2, zonedDateTime));
                    iterator.remove();
                    continue;
                }
                ((Logger)Manager.of(Logger.class)).finest(Scheduler.class, "One shot task is scheduled for {}", new Object[]{object2.a});
                if (chronoZonedDateTime != null && !((ZonedDateTime)object2.a).isBefore(chronoZonedDateTime)) continue;
                chronoZonedDateTime = (ZonedDateTime)object2.a;
            }
            if (chronoZonedDateTime != null && chronoZonedDateTime.isBefore(zonedDateTime)) {
                ((Logger)Manager.of(Logger.class)).finest(Scheduler.class, (Object)"Next task is past due. Looping now.");
                continue;
            }
            try {
                object2 = locker;
                synchronized (object2) {
                    if (chronoZonedDateTime == null) {
                        ((Logger)Manager.of(Logger.class)).finest(Scheduler.class, (Object)"No future tasks to perform. Sleeping until further notice.");
                        locker.wait();
                    } else {
                        long l = ChronoUnit.MILLIS.between(zonedDateTime, chronoZonedDateTime);
                        if (l <= 0L) {
                            continue;
                        }
                        ((Logger)Manager.of(Logger.class)).finest(Scheduler.class, "Next task scheduled at {}. Sleeping for {}ms.", new Object[]{chronoZonedDateTime, l});
                        locker.wait(l);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    });

    public static void register() {
    }

    protected Class<? extends Implementation> defaultTarget() {
        return Implementation.class;
    }

    protected Supplier<? extends Implementation> defaultCreator() {
        return () -> new Implementation();
    }

    public Template<? extends Scheduler> template() {
        return super.template().summary("Task scheduler").description("This task scheduler is designed to optimize the processing power by sleeping until the next task has to run instead of waking up at regular interval. This allows a finer granularity in task scheduling without requiring constant checks.").onCreate((data, scheduler) -> {
            if (((Lifecycle)Manager.of(Lifecycle.class)).phase() == Lifecycle.Phase.RUN) {
                origin.start();
            } else {
                Lifecycle.before((Lifecycle.Phase)Lifecycle.Phase.RUN, (Callback.Once)Callback.once(() -> origin.start()));
            }
        });
    }

    private static /* synthetic */ void lambda$static$1(Tuples.Tuple tuple, ZonedDateTime zonedDateTime) throws Exception {
        ((Consumer)tuple.b).accept(zonedDateTime);
    }

    private static /* synthetic */ void lambda$static$0(Scheduler.Cron.Type type, ZonedDateTime zonedDateTime) throws Exception {
        type.accept(zonedDateTime);
    }

    private static class Implementation
    extends Scheduler
    implements Closeable {
        private volatile ZonedDateTime next = null;

        private Implementation() {
        }

        public void at(Consumer<ZonedDateTime> consumer, ZonedDateTime zonedDateTime) {
            ZonedDateTime zonedDateTime2 = ZonedDateTime.now().withNano(0);
            if (zonedDateTime.isBefore(zonedDateTime2)) {
                ((Executor)Manager.of(Executor.class)).priority(() -> consumer.accept(zonedDateTime2));
                return;
            }
            once.add((Tuples.Tuple<ZonedDateTime, Consumer<ZonedDateTime>>)new Tuples.Tuple((Object)zonedDateTime, consumer));
            if (this.next == null || zonedDateTime.isBefore(this.next)) {
                this.refresh();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh() {
            Object object = locker;
            synchronized (object) {
                locker.notifyAll();
            }
        }

        @Override
        public void close() {
            if (origin == null) {
                return;
            }
            origin.stop();
        }
    }
}

